////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  ASLicenseValidator.h
//    Class for reading and validating a license.
//
//  Copyright © 2010-2015 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//	11/02/15  K.L.S.  Modified for differnt machine id generation.
//	10/12/11  A.L.L.  Allow specification of required keys when validating license file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright © 2009 MYOB Technology Pty. Ltd., all rights reserved.
//
//  Change History (most recent first):
//
//	02/25/09  K.L.S.  Created File.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"
#include "ASObject.h"

namespace ASFoundation
{
	class EXTERNAL_API ASLicenseValidator : public ASObject
	{
	public:
		enum 
		{
			kMachineIdNotFoundErrorId = 1,
			kEmptyLicenseFileErrorId,
			kUnableToSaveLicenseFileErrorId,
			kInvalidLicenseFileErrorId
		};

		virtual ~ASLicenseValidator(void);

		static CPString FormatMachineId(const CPString& UnformattedMachineId);

		static ASLicenseValidator* CreateWithPublicKeyAndMatchEntries(const CPString& PublicKey, const CPDictionary& EntriesToMatch);
		static ASLicenseValidator* CreateWithLicensePathPublicKeyAndMatchEntries(const CPString& LicensePath, const CPString& PublicKey,
																				 const CPDictionary& EntriesToMatch);

		bool IsValid(void);

		CPDictionary LicenseDictionary(void) const;
		virtual CPString MachineId(void) const;
		virtual CPString AltMachineId(void) const;

		CPError CreateLicenseFileWithData(const CPData& LicenseData, const CPString& LicenseFilePath);

	protected:
		ASLicenseValidator(void);
		ASLicenseValidator(const CPString& PublicKey);
		ASLicenseValidator(const CPString& PublicKey, const CPDictionary& EntriesToMatch);

		bool HasMatchingEntries(const CPDictionary& EntriesToMatch);
		bool IsValidAndHasMatchingEntries(const CPDictionary& EntriesToMatch);

		// Generating dictionary from license data/files
		virtual CPDictionary CreateDictionaryForLicenseFile(const CPString& LicenseFilePath) = 0;

		// Generating license data/files
		CPError CreateLicenseFileWithDictionary(const CPDictionary& LicenseDictionary, const CPString& LicenseFilePath);

		CPString PublicKey(void) const;

		virtual bool DictionaryHasMatchingMachineId(const CPDictionary& LicenseDictionary) const;
		virtual bool HasMatchingMachineId(const CPString& MachineId) const;

		virtual CPString MachineUniqueIdentifier(void) const = 0;
		void SetPublicKey(const CPString& PublicKey);
		bool LoadLicenseFile(const CPString& LicenseFilePath);
		
	private:
		CPString m_PublicKey;
		CPDictionary m_License;
		CPDictionary m_MatchEntries;
	};
}

